<?php

namespace App\Http\Middleware;

use App\Providers\RouteServiceProvider;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RedirectIfAuthenticated
{
    public function handle(Request $request, Closure $next, string ...$guards): Response
    {
        $guards = empty($guards) ? [null] : $guards;

        foreach ($guards as $guard) {
            if (Auth::guard($guard)->check()) {
                $user = Auth::guard($guard)->user();
                return redirect($this->redirectTo($user));
            }
        }

        return $next($request);
    }

    private function redirectTo($user)
    {
        return match($user->role) {
            'admin' => '/admin/dashboard',
            'doctor' => '/doctor/dashboard',
            'pharmacist' => '/pharmacist/dashboard',
            default => '/',
        };
    }
}

